/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.axis;

import filenet.vw.base.XMLHelper;
import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SOAPMessageUtils {
    protected static Logger logger = Logger.getLogger("filenet.ws.listener.axis");
    protected static Logger detailLogger = Logger.getLogger("filenet.ws.listener.axis.detail");
    private static final String m_className = "SOAPMessageUtils";
    protected static boolean detailFinest = false;
    private static String EOL;

    public static void NameToString(Name name, StringBuffer buf, boolean includingNS) {
        if (name == null) {
            return;
        }
        String prefix = name.getPrefix();
        if (prefix == null) {
            buf.append(name.getLocalName());
        } else {
            buf.append(prefix).append(":").append(name.getLocalName());
            if (includingNS) {
                buf.append(" xmlns:").append(prefix).append("=\"").append(name.getURI()).append("\"");
            }
        }
    }

    private static String exploreName(Name name) {
        if (name == null) {
            return "null";
        }
        String prefix = name.getPrefix();
        prefix = prefix == null ? "" : prefix + ":";
        return prefix + name.getLocalName() + " nsURI=" + name.getURI() + " qName=" + name.getQualifiedName();
    }

    private static String getName(SOAPElement el) {
        Name name = el.getElementName();
        return name.getQualifiedName();
    }

    private static void exploreAttributes(StringBuffer buf, SOAPElement el) {
        Iterator iter = el.getAllAttributes();
        if (iter == null) {
            return;
        }
        String m_method = "exploreAttributes";
        while (iter.hasNext()) {
            Name n = (Name)iter.next();
            String nURI = n.getURI();
            String nPrefix = n.getPrefix();
            String realN = n.getQualifiedName();
            if (nURI == null || nURI.trim().length() == 0) {
                realN = n.getLocalName();
            }
            if (detailFinest) {
                detailLogger.finest(m_className, "exploreAttributes", realN);
            }
            buf.append(EOL).append(" ").append(realN).append("=\"").append(XMLHelper.toXMLString(el.getAttributeValue(n))).append("\"");
        }
    }

    private static void exploreNode(StringBuffer buf, Object node) {
        String m_method = "exploreNode";
        if (node instanceof Node && node instanceof SOAPElement) {
            SOAPMessageUtils.exploreSOAPElement(buf, (SOAPElement)node);
        }
    }

    public static String getSOAPElementAsStringWithNS(SOAPElement el) {
        if (el == null) {
            return "";
        }
        String m_method = "getSOAPElementAsStringWithNS";
        StringBuffer buf = new StringBuffer();
        String nameS = SOAPMessageUtils.getElementQualifiedName(el);
        buf.append(EOL).append("<").append(nameS).append(" ");
        SOAPMessageUtils.exploreNamespaces(buf, el, true);
        SOAPMessageUtils.exploreAttributes(buf, el);
        if (el instanceof SOAPEnvelope) {
            try {
                buf.append(">");
                SOAPBody b = ((SOAPEnvelope)el).getBody();
                SOAPMessageUtils.exploreSOAPElement(buf, (SOAPElement)b);
            }
            catch (Exception e) {
                logger.throwing(m_className, "getSOAPElementAsStringWithNS", e);
            }
            buf.append("</").append(nameS).append(">");
        } else {
            String val = el.getValue();
            boolean hasValue = val != null && val.trim().length() > 0;
            Iterator iter = el.getChildElements();
            if (iter != null && iter.hasNext()) {
                buf.append(">");
                while (iter.hasNext()) {
                    SOAPMessageUtils.exploreNode(buf, iter.next());
                }
                if (hasValue) {
                    buf.append(XMLHelper.toXMLString(val));
                }
                buf.append(EOL).append("</").append(nameS).append(">");
            } else if (hasValue) {
                buf.append(">").append(XMLHelper.toXMLString(val)).append("</").append(nameS).append(">");
            } else {
                buf.append("/>");
            }
        }
        String s = buf.toString();
        if (detailFinest) {
            detailLogger.finest(m_className, "getSOAPElementAsStringWithNS", s);
        }
        return s;
    }

    public static String getSOAPElementAsString(SOAPElement el) {
        String m_method = "getSOAPElementAsString";
        StringBuffer buf = new StringBuffer();
        SOAPMessageUtils.exploreSOAPElement(buf, el);
        String s = buf.toString();
        if (detailFinest) {
            detailLogger.finest(m_className, "getSOAPElementAsString", s);
        }
        return s;
    }

    private static void exploreSOAPElement(StringBuffer buf, SOAPElement el) {
        String m_method = "exploreSOAPElement";
        if (el == null) {
            return;
        }
        String nameS = SOAPMessageUtils.getElementQualifiedName(el);
        buf.append(EOL).append("<").append(nameS).append(" ");
        SOAPMessageUtils.exploreNamespaces(buf, el, false);
        SOAPMessageUtils.exploreAttributes(buf, el);
        if (el instanceof SOAPEnvelope) {
            try {
                buf.append(">");
                SOAPMessageUtils.exploreSOAPElement(buf, (SOAPElement)((SOAPEnvelope)el).getHeader());
                SOAPMessageUtils.exploreSOAPElement(buf, (SOAPElement)((SOAPEnvelope)el).getBody());
            }
            catch (Exception e) {
                logger.throwing(m_className, "exploreSOAPElement", e);
            }
            buf.append("</").append(nameS).append(">");
        } else {
            String val = el.getValue();
            boolean hasValue = val != null && val.trim().length() > 0;
            Iterator iter = el.getChildElements();
            if (iter != null && iter.hasNext()) {
                buf.append(">");
                while (iter.hasNext()) {
                    SOAPMessageUtils.exploreNode(buf, iter.next());
                }
                if (hasValue) {
                    buf.append(XMLHelper.toXMLString(val));
                }
                buf.append(EOL).append("</").append(nameS).append(">");
            } else if (hasValue) {
                buf.append(">").append(XMLHelper.toXMLString(val)).append("</").append(nameS).append(">");
            } else {
                buf.append("/>");
            }
        }
    }

    public static StringBuffer exploreMessage(SOAPMessage message) {
        StringBuffer buf = new StringBuffer();
        if (message != null) {
            try {
                SOAPMessageUtils.exploreSOAPElement(buf, (SOAPElement)message.getSOAPPart().getEnvelope());
                MimeHeaders headers = message.getMimeHeaders();
                if (headers != null) {
                    Iterator iter = headers.getAllHeaders();
                    while (iter != null && iter.hasNext()) {
                        MimeHeader header = (MimeHeader)iter.next();
                        String headerName = header.getName();
                        String headerValue = header.getValue();
                        buf.append("<MIME HEADER ").append(headerName).append("=").append(headerValue).append("/>");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return buf;
    }

    public static boolean equalNames(Name name, QName qName, boolean ignoreNamespace) {
        if (name == null || qName == null || name.getLocalName() == null || !ignoreNamespace && name.getURI() == null) {
            return false;
        }
        boolean res = name.getLocalName().equals(qName.getLocalPart());
        if (!ignoreNamespace) {
            return res && name.getURI().equals(qName.getNamespaceURI());
        }
        return res;
    }

    public static Iterator getChildElementsForName(SOAPElement element, QName qName, boolean ignoreNamespace) {
        if (element == null || qName == null) {
            return null;
        }
        Iterator iter = element.getChildElements();
        if (iter == null) {
            return null;
        }
        Vector v = new Vector();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof SOAPElement) || !SOAPMessageUtils.equalNames(((SOAPElement)o).getElementName(), qName, ignoreNamespace)) continue;
            v.add(o);
        }
        if (v.size() == 0) {
            return null;
        }
        return v.iterator();
    }

    public static void inspectAttribute(SOAPElement el, Hashtable attrValueToElements, Hashtable attrValueToNames, String attribLocalName) {
        Iterator iter2;
        if (el == null) {
            return;
        }
        Iterator iter = el.getAllAttributes();
        if (iter != null) {
            while (iter.hasNext()) {
                Name n = (Name)iter.next();
                if (!n.getLocalName().equals(attribLocalName)) continue;
                String val = el.getAttributeValue(n);
                attrValueToElements.put(val, el);
                attrValueToNames.put(val, n);
                break;
            }
        }
        if ((iter2 = el.getChildElements()) != null) {
            while (iter2.hasNext()) {
                Object o = iter2.next();
                if (!(o instanceof SOAPElement)) continue;
                SOAPMessageUtils.inspectAttribute((SOAPElement)o, attrValueToElements, attrValueToNames, attribLocalName);
            }
        }
    }

    private static void getNamespaces(SOAPElement el, Hashtable res, boolean fromParentToo) {
        if (el == null) {
            return;
        }
        do {
            Iterator iter2;
            if ((iter2 = el.getNamespacePrefixes()) != null) {
                while (iter2.hasNext()) {
                    String nsPrefix = (String)iter2.next();
                    String nsURI = el.getNamespaceURI(nsPrefix);
                    if (nsPrefix == null || nsURI == null) continue;
                    res.put(nsPrefix, nsURI);
                }
            }
            if (!fromParentToo) {
                return;
            }
            el = el.getParentElement();
        } while (el != null);
    }

    private static void exploreNamespaces(StringBuffer buf, SOAPElement el, boolean fromParentToo) {
        Enumeration enum1;
        String m_method = "exploreNamespaces";
        Hashtable nsInfo = new Hashtable();
        SOAPMessageUtils.getNamespaces(el, nsInfo, fromParentToo);
        if (nsInfo != null && (enum1 = nsInfo.keys()) != null) {
            while (enum1.hasMoreElements()) {
                String nsPrefix = (String)enum1.nextElement();
                if (detailFinest) {
                    detailLogger.finest(m_className, "exploreNamespaces", nsPrefix);
                }
                if (nsPrefix == null) continue;
                buf.append(EOL).append(" xmlns");
                if (nsPrefix.trim().length() > 0) {
                    buf.append(EOL).append(":").append(nsPrefix.trim());
                }
                buf.append("=\"").append(nsInfo.get(nsPrefix)).append("\"");
            }
        }
    }

    private static String getElementQualifiedName(SOAPElement el) {
        String nameS;
        String m_method = "getElementQualifiedName";
        if (el == null) {
            return null;
        }
        String res = el.getElementName().getQualifiedName();
        if (detailFinest) {
            detailLogger.finest(m_className, "getElementQualifiedName", "getElementName().getQualifiedName=" + res);
        }
        if ((nameS = el.getElementName().getPrefix()) == null || nameS.trim().length() == 0) {
            res = el.getElementName().getLocalName();
        }
        if (detailFinest) {
            detailLogger.finest(m_className, "getElementQualifiedName", res);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBodyChildElementsAsString(SOAPBody body) {
        Iterator iter;
        block5: {
            String m_method = "getBodyChildElementsAsString";
            logger.entering(m_className, "getBodyChildElementsAsString");
            iter = body.getChildElements();
            if (iter != null) break block5;
            String string = null;
            Object var7_5 = null;
            logger.exiting(m_className, "getBodyChildElementsAsString");
            return string;
        }
        try {
            StringBuffer buf2 = new StringBuffer();
            while (iter.hasNext()) {
                SOAPElement el = (SOAPElement)iter.next();
                SOAPMessageUtils.exploreSOAPElement(buf2, el);
            }
            String msg2 = buf2.toString();
            if (logger.isFinest()) {
                logger.finest(m_className, "getBodyChildElementsAsString", msg2);
            }
            String string = msg2;
            Object var7_6 = null;
            logger.exiting(m_className, "getBodyChildElementsAsString");
            return string;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            logger.exiting(m_className, "getBodyChildElementsAsString");
            throw throwable;
        }
    }

    public static String getRPCBodyChildElementsAsString(SOAPBody body, String[] accessors, String[] msgParts) {
        int nParts;
        Iterator iter;
        String m_method = "getRPCBodyChildElementsAsString";
        detailLogger.entering(m_className, "getRPCBodyChildElementsAsString");
        String origSOAPMsgString = SOAPMessageUtils.getSOAPElementAsString(body.getParentElement());
        String newSOAPString = SOAPMessageUtils.parseSoapMessage(origSOAPMsgString);
        if (!newSOAPString.equals(origSOAPMsgString)) {
            try {
                MessageFactory messageFactory = MessageFactory.newInstance();
                SOAPMessage message = messageFactory.createMessage(new MimeHeaders(), (InputStream)new ByteArrayInputStream(newSOAPString.getBytes("UTF-8")));
                body = message.getSOAPPart().getEnvelope().getBody();
            }
            catch (Exception e) {
                logger.throwing(m_className, "getRPCBodyChildElementsAsString", e);
            }
        }
        if ((iter = body.getChildElements()) == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int n = nParts = msgParts == null ? 0 : msgParts.length;
        while (iter.hasNext()) {
            SOAPBodyElement bodyElement = (SOAPBodyElement)iter.next();
            Iterator iter2 = bodyElement.getChildElements();
            while (iter2.hasNext()) {
                SOAPElement el = (SOAPElement)iter2.next();
                String elStr = SOAPMessageUtils.getSOAPElementAsStringWithNS(el);
                if (nParts > 0) {
                    String localName = el.getElementName().getLocalName();
                    boolean foundIt = false;
                    for (int i = 0; i < nParts && !foundIt; ++i) {
                        if (!localName.equals(accessors[i])) continue;
                        int ii = elStr.indexOf(localName);
                        int jj = elStr.lastIndexOf(localName);
                        if (jj == ii) continue;
                        buf.append(elStr.substring(0, ii));
                        buf.append(msgParts[i]);
                        buf.append(elStr.substring(ii + localName.length(), jj));
                        buf.append(msgParts[i]);
                        buf.append(elStr.substring(jj + localName.length()));
                        foundIt = true;
                    }
                    if (foundIt) continue;
                    buf.append(elStr);
                    continue;
                }
                buf.append(elStr);
            }
        }
        String msg = buf.toString();
        if (detailFinest) {
            detailLogger.finest(m_className, "getRPCBodyChildElementsAsString", msg);
        }
        return msg;
    }

    private static void deepCopyElement(Element src, Element dest) {
        if (src == null || dest == null) {
            return;
        }
        NamedNodeMap attrs = src.getAttributes();
        int nAttrs = attrs == null ? 0 : attrs.getLength();
        for (int j = 0; j < nAttrs; ++j) {
            Attr attrib;
            org.w3c.dom.Node node = attrs.item(j);
            if (node.getNodeType() != 2 || (attrib = (Attr)node) == null) continue;
            dest.setAttribute(attrib.getName(), attrib.getValue());
        }
        NodeList children = src.getChildNodes();
        int nChildren = children == null ? 0 : children.getLength();
        for (int i = 0; i < nChildren; ++i) {
            org.w3c.dom.Node child = children.item(i);
            org.w3c.dom.Node newChild = child.cloneNode(true);
            dest.appendChild(newChild);
        }
    }

    private static String getAttributeValueWithLocalName(org.w3c.dom.Node el, String attrLocalName) {
        if (el == null || attrLocalName == null) {
            return null;
        }
        NamedNodeMap m = el.getAttributes();
        int nAttrs = m == null ? 0 : m.getLength();
        for (int i = 0; i < nAttrs; ++i) {
            org.w3c.dom.Node n = m.item(i);
            if (!n.getNodeName().endsWith(attrLocalName)) continue;
            return n.getNodeValue();
        }
        return null;
    }

    private static boolean fixedUpArrays(org.w3c.dom.Node el) {
        NodeList children;
        boolean res = false;
        if (el == null || !(el instanceof Element)) {
            return false;
        }
        String realType = null;
        String typeStr = SOAPMessageUtils.getAttributeValueWithLocalName(el, "arrayType");
        if (typeStr != null) {
            int localNameIndex = typeStr.indexOf(58);
            localNameIndex = localNameIndex == -1 ? 0 : ++localNameIndex;
            int bracketIndex = typeStr.indexOf(91, localNameIndex);
            if (bracketIndex == -1) {
                bracketIndex = typeStr.length();
            }
            realType = typeStr.substring(localNameIndex, bracketIndex);
        }
        int nChildren = (children = el.getChildNodes()) == null ? 0 : children.getLength();
        for (int i = 0; i < nChildren; ++i) {
            org.w3c.dom.Node oldChild = children.item(i);
            if (!(oldChild instanceof Element)) continue;
            res |= SOAPMessageUtils.fixedUpArrays(oldChild);
            if (realType == null) continue;
            Element newChild = oldChild.getOwnerDocument().createElement(realType);
            SOAPMessageUtils.deepCopyElement((Element)oldChild, newChild);
            el.replaceChild(newChild, oldChild);
            res = true;
        }
        return res;
    }

    private static String parseSoapMessage(String soapMsgXMLDoc) {
        String m_method = "parseSoapMessage";
        try {
            Document doc = XMLHelper.parseDocumentViaDOM(new InputSource(new StringReader(soapMsgXMLDoc)), null, null, false, false);
            Element docElement = doc.getDocumentElement();
            boolean bChanged = false;
            bChanged = SOAPMessageUtils.fixedUpArrays(docElement);
            Hashtable hTable = SOAPMessageUtils.getIdElements(docElement);
            if (!hTable.isEmpty()) {
                bChanged |= SOAPMessageUtils.parseNode(doc, hTable, docElement);
            }
            if (bChanged) {
                soapMsgXMLDoc = SOAPMessageUtils.docToString(doc);
            }
        }
        catch (Exception ex) {
            logger.throwing(m_className, "parseSoapMessage", ex);
        }
        return soapMsgXMLDoc;
    }

    public static String docToString(Document doc) throws IOException {
        if (doc != null) {
            String Encoding = "UTF-8";
            OutputFormat format = new OutputFormat(doc);
            format.setEncoding(Encoding);
            format.setIndenting(true);
            StringWriter stringOut = new StringWriter();
            XMLSerializer serial = new XMLSerializer((Writer)stringOut, format);
            serial.asDOMSerializer();
            serial.serialize(doc);
            String s = stringOut.toString();
            return s;
        }
        return new String();
    }

    private static boolean parseNode(Document doc, Hashtable hTable, org.w3c.dom.Node node) {
        boolean bChanged = false;
        if (node.getNodeType() == 1) {
            NodeList children;
            String hrefId;
            Object obj;
            String hrefValue;
            Element elt = (Element)node;
            NamedNodeMap attributes = elt.getAttributes();
            org.w3c.dom.Node href = attributes.getNamedItem("href");
            org.w3c.dom.Node id = attributes.getNamedItem("id");
            if (href != null && (hrefValue = href.getNodeValue()) != null && hrefValue.startsWith("#") && (obj = hTable.get(hrefId = hrefValue.substring(1))) != null && obj instanceof Element) {
                bChanged = true;
                Element idElement = (Element)obj;
                org.w3c.dom.Node parentNode = idElement.getParentNode();
                if (parentNode != null) {
                    parentNode.removeChild(idElement);
                }
                elt.removeAttribute("href");
                idElement.removeAttribute("id");
                SOAPMessageUtils.deepCopyElement(idElement, elt);
            }
            int nChildren = (children = elt.getChildNodes()) == null ? 0 : children.getLength();
            for (int i = 0; i < nChildren; ++i) {
                node = children.item(i);
                if (node == null) continue;
                bChanged |= SOAPMessageUtils.parseNode(doc, hTable, node);
            }
        }
        return bChanged;
    }

    private static Hashtable getIdElements(Element element) {
        Hashtable<String, Element> hTable = new Hashtable<String, Element>();
        if (element == null) {
            return hTable;
        }
        String idValue = element.getAttribute("id");
        if (idValue != null && idValue.length() > 0) {
            hTable.put(idValue, element);
        } else {
            NodeList children = element.getChildNodes();
            int nChildren = children == null ? 0 : children.getLength();
            for (int i = 0; i < nChildren; ++i) {
                org.w3c.dom.Node node = children.item(i);
                if (node == null || node.getNodeType() != 1) continue;
                hTable.putAll(SOAPMessageUtils.getIdElements((Element)node));
            }
        }
        return hTable;
    }

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:04:12  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.28  $";
    }

    static {
        detailFinest = detailLogger.isLoggable(Level.FINEST);
        logger.finest(m_className, "static initialializer", SOAPMessageUtils._get_FILE_REVISION());
        EOL = "";
    }
}

